/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: GPIO_Struct.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    netX GPIO definitions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-24  File created.

**************************************************************************************/


#ifndef _GPIO_STRUCT_H
#define _GPIO_STRUCT_H


/*************************************************************************************/

#define GPIO_COUNT  32
#define TIMER_COUNT 5

/* structure map of netX GPIO registers */

typedef struct NETX_GPIO_REGISTERS_Ttag
{
  volatile unsigned long ulCfg[GPIO_COUNT];
  volatile unsigned long ulTc[GPIO_COUNT];
  volatile unsigned long ulCounterCtrl[TIMER_COUNT];
  volatile unsigned long ulCounterMax[TIMER_COUNT];
  volatile unsigned long ulCounter[TIMER_COUNT];
  volatile unsigned long ulSystimeCmp;
  volatile unsigned long ulLine;
  volatile unsigned long ulIn;
  volatile unsigned long ulGpioIrqRaw;
  volatile unsigned long ulGpioIrqMasked;
  volatile unsigned long ulGpioIrqMaskSet;
  volatile unsigned long ulGpioIrqMaskReset;
  volatile unsigned long ulCntIrqRaw;
  volatile unsigned long ulCntIrqMasked;
  volatile unsigned long ulCntIrqMaskSet;
  volatile unsigned long ulCntIrqMaskReset;
} NETX_GPIO_REGISTERS_T;

#endif
